/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animatable;

import java.util.function.Consumer;
import net.minecraft.class_1297;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.cache.SyncedSingletonAnimatableCache;
import software.bernie.geckolib.constant.dataticket.SerializableDataTicket;

public interface SingletonGeoAnimatable
extends GeoAnimatable {
    public static void registerSyncedAnimatable(SingletonGeoAnimatable animatable) {
        SyncedSingletonAnimatableCache.registerSyncedAnimatable(animatable);
    }

    @ApiStatus.NonExtendable
    default public <D> @Nullable D getAnimData(long instanceId, SerializableDataTicket<D> dataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(instanceId).getAnimatableData(dataTicket);
    }

    @ApiStatus.NonExtendable
    default public <D> void setAnimData(class_1297 relatedEntity, long instanceId, SerializableDataTicket<D> dataTicket, D data) {
        if (relatedEntity.method_73183().method_8608()) {
            this.getAnimatableInstanceCache().getManagerForId(instanceId).setAnimatableData(dataTicket, data);
        } else {
            this.syncAnimData(instanceId, dataTicket, data, relatedEntity);
        }
    }

    @ApiStatus.NonExtendable
    default public <D> void syncAnimData(long instanceId, SerializableDataTicket<D> dataTicket, D data, class_1297 entityToTrack) {
        GeckoLibServices.NETWORK.syncSingletonAnimData(this, instanceId, dataTicket, data, entityToTrack);
    }

    @ApiStatus.NonExtendable
    default public void triggerAnim(class_1297 relatedEntity, long instanceId, @Nullable String controllerName, String animName) {
        if (relatedEntity.method_73183().method_8608()) {
            AnimatableManager animatableManager = this.getAnimatableInstanceCache().getManagerForId(instanceId);
            if (controllerName != null) {
                animatableManager.tryTriggerAnimation(controllerName, animName);
            } else {
                animatableManager.tryTriggerAnimation(animName);
            }
        } else {
            GeckoLibServices.NETWORK.triggerSingletonAnim(this, relatedEntity, instanceId, controllerName, animName);
        }
    }

    @ApiStatus.NonExtendable
    default public void stopTriggeredAnim(class_1297 relatedEntity, long instanceId, @Nullable String controllerName, @Nullable String animName) {
        if (relatedEntity.method_73183().method_8608()) {
            AnimatableManager animatableManager = this.getAnimatableInstanceCache().getManagerForId(instanceId);
            if (controllerName != null) {
                animatableManager.stopTriggeredAnimation(controllerName, animName);
            } else {
                animatableManager.stopTriggeredAnimation(animName);
            }
        } else {
            GeckoLibServices.NETWORK.stopTriggeredSingletonAnim(this, relatedEntity, instanceId, controllerName, animName);
        }
    }

    @ApiStatus.NonExtendable
    default public void triggerArmorAnim(class_1297 relatedEntity, long instanceId, @Nullable String controllerName, String animName) {
        this.triggerAnim(relatedEntity, -instanceId, controllerName, animName);
    }

    @ApiStatus.NonExtendable
    default public void stopTriggeredArmorAnim(class_1297 relatedEntity, long instanceId, @Nullable String controllerName, @Nullable String animName) {
        this.stopTriggeredAnim(relatedEntity, -instanceId, controllerName, animName);
    }

    @Override
    default public @Nullable AnimatableInstanceCache animatableCacheOverride() {
        return new SingletonAnimatableInstanceCache(this);
    }

    default public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
    }

    default public Object getRenderProvider() {
        return this.getAnimatableInstanceCache().getRenderProvider();
    }
}

